IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME ='EST_PROD_TRANSF_GERAL_CPL')
BEGIN

	
	CREATE TABLE [dbo].[EST_PROD_TRANSF_GERAL_CPL](
		[CD_CTR] [int] NOT NULL,
		[CD_EMP] [int] NOT NULL,
		[CD_PROD] [int] NOT NULL,
		[CD_SIGLA] [int] NOT NULL,
		[CD_ARV_MERC_LINHA] [int] NOT NULL,
		[QT_UNI_RESSUPRIMENTO] [int] NOT NULL,
		[QT_NECESSIDADE] MONEY NOT NULL,
		[QT_AT] MONEY NOT NULL,
		[QT_EST] MONEY NOT NULL,
		[QT_PEND] MONEY NOT NULL,
		[QT_EMAX] MONEY NOT NULL,
		[QT_ESEG] MONEY NOT NULL,
		[EMAX]		MONEY NOT NULL,
		[ESEG]		MONEY NOT NULL,
		[MEDIAF]	MONEY NOT NULL,
		[PARAM_ESPECIAL] TINYINT NOT NULL,
		[FDIAS]	INT  NOT NULL,
		[FLAG_RESSUPRIMENTO_CAIXA_FECHADA] TINYINT NOT NULL,
		[SALDO] AS (QT_NECESSIDADE-QT_AT) ,
	 CONSTRAINT [PK_EST_PROD_TRANSF_GERAL_CPL] PRIMARY KEY CLUSTERED 
	(
		[CD_CTR] ASC,	
		[CD_EMP] ASC,
		[CD_PROD] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 97) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[EST_PROD_TRANSF_GERAL_CPL] ADD  CONSTRAINT [DF_EST_PROD_TRANSF_GERAL_CPL_CD_CTR]		DEFAULT ((0)) FOR [CD_CTR]
	ALTER TABLE [dbo].[EST_PROD_TRANSF_GERAL_CPL] ADD  CONSTRAINT [DF_EST_PROD_TRANSF_GERAL_CPL_CD_EMP]		DEFAULT ((0)) FOR [CD_EMP]
	ALTER TABLE [dbo].[EST_PROD_TRANSF_GERAL_CPL] ADD  CONSTRAINT [DF_EST_PROD_TRANSF_GERAL_CPL_CD_PROD]	DEFAULT ((0)) FOR [CD_PROD]
	ALTER TABLE [dbo].[EST_PROD_TRANSF_GERAL_CPL] ADD  CONSTRAINT [DF_EST_PROD_TRANSF_GERAL_CPL_QT_UNI_RESSUPRIMENTO]	DEFAULT ((0)) FOR [QT_UNI_RESSUPRIMENTO]

	ALTER TABLE [dbo].[EST_PROD_TRANSF_GERAL_CPL] ADD  CONSTRAINT [DF_EST_PROD_TRANSF_GERAL_CPL_CD_SIGLA]	DEFAULT ((4)) FOR [CD_SIGLA]
	ALTER TABLE [dbo].[EST_PROD_TRANSF_GERAL_CPL] ADD  CONSTRAINT [DF_EST_PROD_TRANSF_GERAL_CPL_QT_NECESSIDADE]	DEFAULT ((0)) FOR [QT_NECESSIDADE]
	ALTER TABLE [dbo].[EST_PROD_TRANSF_GERAL_CPL] ADD  CONSTRAINT [DF_EST_PROD_TRANSF_GERAL_CPL_QT_AT]	DEFAULT ((0)) FOR [QT_AT]

	ALTER TABLE [dbo].[EST_PROD_TRANSF_GERAL_CPL]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TRANSF_GERAL_CPL_EST_PROD_TRANSF_GERAL] FOREIGN KEY([CD_CTR])
				REFERENCES [dbo].[EST_PROD_TRANSF_GERAL] ([CD_CTR]) ON DELETE CASCADE;
	ALTER TABLE [dbo].[EST_PROD_TRANSF_GERAL_CPL] CHECK CONSTRAINT [FK_EST_PROD_TRANSF_GERAL_CPL_EST_PROD_TRANSF_GERAL]

	ALTER TABLE [dbo].[EST_PROD_TRANSF_GERAL_CPL]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TRANSF_GERAL_CPL_EST_PROD] FOREIGN KEY([CD_EMP], [CD_PROD])
				REFERENCES [dbo].[EST_PROD] ([CD_EMP], [CD_PROD])
	ALTER TABLE [dbo].[EST_PROD_TRANSF_GERAL_CPL] CHECK CONSTRAINT [FK_EST_PROD_TRANSF_GERAL_CPL_EST_PROD]

END
   